/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;

public class SmartMateGoal
extends Goal {
    private final ComplexMob taskOwner;
    private final Level world;
    private final int executionChance;
    private final Class<? extends ComplexMob> mateClass;
    private ComplexMob targetMate;
    private int spawnBabyDelay;
    private final double moveSpeed;

    public SmartMateGoal(ComplexMob entityIn, double speedIn) {
        this(entityIn, speedIn, 120, ((Object)((Object)entityIn)).getClass());
    }

    private SmartMateGoal(ComplexMob entityIn, double speedIn, int chance, Class<? extends ComplexMob> mateClass) {
        this.taskOwner = entityIn;
        this.world = entityIn.f_19853_;
        this.mateClass = mateClass;
        this.executionChance = chance;
        this.moveSpeed = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.taskOwner.m_27593_() || this.taskOwner.m_146764_() != 0) {
            return false;
        }
        if (this.taskOwner.m_21187_().nextInt(this.executionChance) != 0) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean m_8045_() {
        return this.targetMate.m_6084_() && this.targetMate.m_27593_() && this.spawnBabyDelay < 200;
    }

    public void m_8041_() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void m_8037_() {
        this.taskOwner.m_21563_().m_24960_((Entity)this.targetMate, 10.0f, (float)this.taskOwner.m_21529_());
        this.taskOwner.m_21573_().m_26519_(this.targetMate.m_20185_(), this.targetMate.m_20186_(), this.targetMate.m_20189_(), this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 100 && this.taskOwner.m_20280_((Entity)this.targetMate) < 9.0) {
            this.taskOwner.m_27594_();
            this.targetMate.m_27594_();
            if (this.world.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.world.m_7967_((Entity)new ExperienceOrb(this.world, this.taskOwner.m_20185_(), this.taskOwner.m_20186_(), this.taskOwner.m_20189_(), this.taskOwner.m_21187_().nextInt(7) + 1));
            }
            this.taskOwner.m_146762_(this.taskOwner.getPregnancyTime());
            this.targetMate.m_146762_(this.taskOwner.getPregnancyTime());
            if (((Boolean)ConfigGamerules.easyBreeding.get()).booleanValue()) {
                if (((Boolean)ConfigGamerules.genderedBreeding.get()).booleanValue()) {
                    this.taskOwner.breed();
                } else if (!this.taskOwner.isMale()) {
                    this.taskOwner.breed();
                } else {
                    this.targetMate.breed();
                }
            }
        }
    }

    private ComplexMob getNearbyMate() {
        List list = this.world.m_45976_(this.mateClass, this.taskOwner.m_142469_().m_82400_(8.0));
        list.remove((Object)this.taskOwner);
        double d0 = Double.MAX_VALUE;
        ComplexMob entityanimal = null;
        for (ComplexMob potentialMates : list) {
            if (!this.canMateWith(this.taskOwner, potentialMates) || !(this.taskOwner.m_20280_((Entity)potentialMates) < d0)) continue;
            entityanimal = potentialMates;
            d0 = this.taskOwner.m_20280_((Entity)potentialMates);
        }
        return entityanimal;
    }

    private boolean canMateWith(ComplexMob father, ComplexMob mother) {
        if (((Boolean)ConfigGamerules.genderedBreeding.get()).booleanValue() && father.getGender() == mother.getGender()) {
            return false;
        }
        if (father.getVariant() != mother.getVariant()) {
            return false;
        }
        if (((Boolean)ConfigGamerules.playerBreeding.get()).booleanValue()) {
            return true;
        }
        return father.wantsToBreed() && mother.wantsToBreed();
    }
}

